/*
 * Copyright (c) 2016, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 *  SWITCH header file
 *
 */

#include "DM8127_types.h"
#include "Dm8127_Platform.h"

#ifndef _SWITCH_
#define _SWITCH_

//#define WR_MEM_32(addr, data)    *(unsigned int*)(addr) = (unsigned int)(data)
//#define RD_MEM_32(addr) 		 *(unsigned int*)(addr)

#define CTRL_MODULE_BASE_ADDR     (0x48140000)

#ifdef PROCESSOR_DM88

#define    PINCNTL41  (CTRL_MODULE_BASE_ADDR + 0x08A0)
#define    PINCNTL42  (CTRL_MODULE_BASE_ADDR + 0x08A4)
#define    PINCNTL232 (CTRL_MODULE_BASE_ADDR + 0x0B9C)

#endif


#ifdef PROCESSOR_DM8127

#define    PINCNTL106  (CTRL_MODULE_BASE_ADDR + 0x09A4)
#define    PINCNTL107  (CTRL_MODULE_BASE_ADDR + 0x09AB)
#define    PINCNTL69   (CTRL_MODULE_BASE_ADDR + 0x0910)
#define    PINCNTL109  (CTRL_MODULE_BASE_ADDR + 0x09B0)

#endif
/* --------------------- *
 *  SWITCH DEFINITIONS                                                      *
 * --------------------- */

#define SWITCH_1  (6u)
#define SWITCH_2  (13u)
#define SWITCH_3  (1u)
#define SWITCH_4  (15u)
#define LOW       (0u)

//extern INT16 switch_test();
/***
 * \brief: switch initialization function.
 *
 * \b \descr:  DM8127 board having four switches connected via BtoB connector
 *
 * \n       switch        connector pin        GPIO pin
 * \n         1                70                 6
 * \n         2                72                 13
 * \n         3                75                 1
 * \n         4                79                 15
 *
 * \param:  VOID
 * \return: SUCCESS
 */
UINT16 switch_init
(
	void
);
/***
 * \brief: check Switch status
 *
 * \b \Descr: This function check the current status of the swtch.
 *
 * \param: VOID
 * \return: SUCCESS
 *
 */

extern UINT16 switch_get_press
(
	void
);

#endif
